;*********************************
;* Jungle Jag - JagCode 500 Game *
;*********************************
;
; by Cedric Bourse, (a.k.a Orion_) [2007]
;
; http://onorisoft.info/
;
; This Source Code is licensed under the term of the following Creative Commons License:
; http://creativecommons.org/licenses/by-nc/3.0/
;
; You are free:
;  * to Share : to copy, distribute and transmit the work
;  * to Remix : to adapt the work
;
; Under the following conditions:
;  * Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).
;  * Noncommercial. You may not use this work for commercial purposes.
;  * For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.
;  * Any of the above conditions can be waived if you get permission from the copyright holder.
;  * Nothing in this license impairs or restricts the author's moral rights.
;

;***************************
;* GPU Part of the program *
;***************************
; Here are all the GPU code and data to be loaded in GPU Cache !

	.68000
	.text

	.long
GPUCode:
	.GPU
	.org     G_RAM

;*****************
;- Main GPU Code -
;*****************

WAITBLITTER	.equ	1	; Tells if you want to wait for the blitter to complete before running your GPU Code


;********************
;* UpdateSpriteList | (Using Blitter = Very Fast !)
;*<------------------

	movei	#A1_BASE,r14

	movei	#SpriteList,r0			; Source
	movei	#OPList+16,r1			; Destination
	moveq	#0,r2				; Pixel
	movei	#PIXEL16|XADDPHR|PITCH1,r3	; Flags
	movei	#$00010000+(MAXSPRITE*2),r4	; Count
	movei	#LFU_REPLACE|SRCEN,r5		; Cmd

	store	r1,(r14)	; A1_BASE
	store	r3,(r14+1)	; A1_FLAGS
	store	r2,(r14+2)	; A1_CLIP <- beware of that one !
	store	r2,(r14+3)	; A1_PIXEL
	store	r0,(r14+9)	; A2_BASE
	store	r3,(r14+10)	; A2_FLAGS
	store	r2,(r14+12)	; A2_PIXEL
	store	r4,(r14+15)	; B_COUNT
	store	r5,(r14+14)	; B_CMD

	.if	WAITBLITTER

	moveq	#1,r6		; Wait Blitter Mask
.waitb:	load	(r14+14),r7	; Wait for the blitter to complete !
	and	r6,r7
	jr	EQ,.waitb
	nop

	.endif

;*****************

	StopGPU

;*****************

	.68000
GPUEnd:
	.print "[GPU code size: ",/u (GPUEnd-GPUCode),"] [GPU Free Memory: ",/u (4096-(GPUEnd-GPUCode)),"]"
